#!/bin/perl

#==============================================================================#
package W2C;
#==============================================================================#
@ISA = qw(JARRAY);

#------------------------------------------------------------------------------#
sub init {
#------------------------------------------------------------------------------#
	my ($ref,@data) = @_;
	
	@$ref = (0);
}

#------------------------------------------------------------------------------#
sub w_in {
#------------------------------------------------------------------------------#
	my ($ref, @wds) = @_;
	if(! @wds) { return ();}
	my $endmark = 0;
	for(my $i=0;$i<=$#wds;$i++) {
		print "{$wds[$i]}";
		push(@$ref,$wds[$i]);
		if(($wds[$i] eq ';')||($wds[$i] eq "\n")) {
			if($$ref[0] == 0) { $endmark = 1;}
		}
		elsif($wds[$i] =~ /^begin$/i) {
			$$ref[0] ++;
		}
		elsif($wds[$i] =~ /^end$/i) {
			$$ref[0] --;
			if($$ref[0] == 0) { $endmark = 1;}
		}
		elsif($wds[$i] eq '(') {
			$$ref[0] ++;
		}
		elsif($wds[$i] eq ')') {
			$$ref[0] --;
		}
		elsif($wds[$i] eq '{') {
			$$ref[0] ++;
		}
		elsif($wds[$i] eq '}') {
			$$ref[0] --;
		}
		elsif($wds[$i] eq '[') {
			$$ref[0] ++;
		}
		elsif($wds[$i] eq ']') {
			$$ref[0] --;
		}
		if($endmark) {
			for($i++;$i<=$#wds;$i++) {
				if($wds[$i] =~ /^[\s]+$/) {
					push(@$ref,$wds[$i]);
				}
				elsif($wds[$i] =~ /^\/\//) {
					push(@$ref,$wds[$i]);
				}
				elsif($wds[$i] =~ /^\/\*/) {
					push(@$ref,$wds[$i]);
				}
				elsif($wds[$i] eq "\n") {
					push(@$ref,$wds[$i]);
					last;
				}
				else {
					$i--;
					last;
				}
			}
			push(@$ref,"COMMAND_END");
		}
	}
}

#------------------------------------------------------------------------------#
sub c_out {
#------------------------------------------------------------------------------#
	my ($ref,@wds) = @_;
	$ref->w_in(@wds);
	for($i=1;$i<=$#$ref;$i++) {
		if($$ref[$i] eq "COMMAND_END") {
			my @wds = @$ref[1..($i -1)];
			@$ref=(@$ref[0],@$ref[($i+1)..$#$ref]);
			return @wds;
		}
	}
	return ();
}

#------------------------------------------------------------------------------#
sub w2c {
#------------------------------------------------------------------------------#
	my ($ref, @wds) = @_;
	$ref->w_in(@wds);
	return($ref->c_out());
}

#------------------------------------------------------------------------------#
sub w2c_filter {
#------------------------------------------------------------------------------#
	my ($ref, @wds) = @_;
	my @owds = ();
	@wds = $ref->w2c(@wds);
	while $awds (@wds) {
		if($awds =~ /^\/\//) {
		}
		elsif($awds =~ /^\/\*/) {
		}
		else {
			push(@owds,$awds);
		}
	}
	@owds;
}

1;
