//==============================================================================
module jmjsrom (clk, addr, dout);
//==============================================================================
parameter WIDTH=1, DEPTH=2, ADDR_WIDTH=1, INIT_FILE="jmjsrom.mif";
//==============================================================================
input				clk;
input	[ADDR_WIDTH -1:0]	addr;
output	[WIDTH -1:0]		dout;
//==============================================================================
reg	[ADDR_WIDTH -1:0]	addr_r;
reg	[WIDTH -1:0]		rcell	[0:DEPTH -1];
//==============================================================================
initial $readmemh(INIT_FILE,rcell);
//initial $readmemh("./jmjsrom.mif",rcell);
//==============================================================================
always @(posedge clk) addr_r = addr;
//==============================================================================
assign dout = rcell[addr_r];
//==============================================================================
endmodule
//==============================================================================
