`timescale 1 ns / 100 ps
module jmjsram8x16 (clk, cs, we, addr, din, dout);
input		clk, cs, we;
input	[3:0]	addr;
input	[7:0]	din;
output	[7:0]	dout;
jmjsram #(8,16,4) u0 (clk, cs, we, addr, din, dout);
endmodule

module jmjsram (clk, cs, we, addr, din, dout);
parameter WIDTH=2, DEPTH=2, ADDR_WIDTH=2;

input				clk, cs, we;
input	[ADDR_WIDTH -1:0]	addr;
input	[WIDTH -1:0]		din;
output	[WIDTH -1:0]		dout;

reg	[WIDTH -1:0]		mem	[0:DEPTH -1];
reg	[ADDR_WIDTH -1:0]	addr_r;
reg				cs_r;
always @(posedge clk) begin
	if(we) mem[addr] <= din;
	addr_r	<= addr;
	cs_r	<= cs;
end

assign dout = (cs_r)? mem[addr_r] : {WIDTH{1'bz}};

endmodule
