`timescale 1 ns / 100 ps
module jmjsram_top;

reg		clk;
initial		clk = 1;
always	begin : Clock
	#6	clk = 0;
	#4	clk = 1;
end

reg		cs;
reg		we;
reg	[ 3:0]	addr;
reg	[ 6:0]	count;
reg	[ 7:0]	din;
initial	begin
		din	<= 0;
		#2;
	for(count=0;count<64;count=count+1) begin
		cs	<= count[5];
		we	<= ~count[4];
		addr	<= count[3:0];
		$display($time," cs=%d we=%d addr=%d din=%d dout=%d",
				cs,we,addr,din,dout);
		#10;
		din	<= din + 1;
	end
		//$stop;
		$finish;
end

wire	[ 7:0]	dout;
jmjsram8x16 u0 (.clk(clk),.cs(cs),.we(we),.addr(addr),.din(din),.dout(dout));

initial begin
	$dumpfile("jmjsram_top.vcd");
	$dumpvars;
end

endmodule
